Vue.component('cpmst-show-subtask', {
    template: '#tmpl-cpmst-show-subtask',
    props: ['task'],
    mixins: [CPM_Task_Mixin, CPM_Subtask],

    computed: {
        is_single_task: function() {
            return this.$store.state.is_single_task;
        }
    },
    methods: {
        showSubTask: function(task) {
            if ( !task.show_subtask ) {
                var self = this,
                    form_data = {
                        task_id: task.ID,
                        _wpnonce: CPMST_var.nonce,
                    };

                wp.ajax.send('cpmst_get_subtasks', {
                    data: form_data,
                    success: function(res) {
                        self.task.subtasks = res.subtasks;
                    },
                    error: function() {
                        toastr.success(CPMST_var.no_subtask);
                    }
                });

                this.task.show_subtask = true;
            } else {
                this.task.show_subtask = false;
                this.task.subtasks = [];
            }
        },
    }
});

Vue.component('cpm-subtask-new-button', {
    template: '#tmpl-cpm-subtask-new-button',
    props: ['task'],
    mixins: [CPM_Task_Mixin, CPM_Subtask],
    computed: {
        is_single_task: function() {
            return this.$store.state.is_single_task;
        }
    },
});

Vue.component('cpm-subtasks',{
    template: '#tmpl-cpm-subtasks',
    props: ['task'],
    mixins: [CPM_Task_Mixin, CPM_Subtask],

    data: function() {
        return {
            subtasks: this.task.subtasks
        }
    },

    created: function() {
        if ( this.$store.state.is_single_task ) {
            this.getSubtask();
        }
    },

    methods: {
        getUser: function(userId) {
            userId = userId || this.$store.state.get_current_user_id;

            var usr = this.$store.state.project_users.find(function(user) {
                return user.id == userId;
            });

            return usr.name;
        },
        is_assigned: function(subtask) {
            var todoList = this.$store.state.lists,
                task = todoList.map(function(list) {
                    var task = list.tasks.find(function(task) {
                        return task.ID == subtask.post_parent;
                    });

                    if (task) {
                        return task;
                    }
                }).filter(function(item) {
                    return item;
                })[0],
                currentUserId = this.$store.state.get_current_user_id,
                inTask = task ? task.assigned_to.indexOf(currentUserId) : -1;

            if ( task && (task.can_del_edit || ( inTask != '-1' )) ) {
                return true;
            }

            return false;
        },

        taskDoneUndone: function( id, completed ) {

            var self = this,
                index = this.getIndex( this.task.subtasks, id, 'ID' );
                action = ( completed == '0' ) ? 'cpmst_subtask_complete' : 'cpmst_subtask_open',
                form_data = {
                    subtask_id: id,
                    _wpnonce: CPMST_var.nonce,
                };

            wp.ajax.send(action, {
                data: form_data,
                success: function(res) {
                    if ( action == 'cpmst_subtask_complete' ) {
                        var list_index = self.getIndex( self.$store.state.lists, self.task.post_parent, 'ID' );
                            task_index = self.getIndex( self.$store.state.lists[list_index].tasks, self.task.ID, 'ID' );

                        self.$store.commit( 'subtaskDone', {
                            list_index: list_index,
                            task_index: task_index,
                            subtask_index: index,
                            meta: {
                                completed_on: res.subtask.completed_on,
                                completed_by: res.subtask.completed_by
                            }
                        } );

                        self.task.subtasks[index].completed = 1;
                        self.task.subtasks[index].completed_on = res.subtask.completed_on;
                        self.task.subtasks[index].completed_by = res.subtask.completed_by;
                    }

                    if ( action == 'cpmst_subtask_open' ) {
                        var list_index = self.getIndex( self.$store.state.lists, self.task.post_parent, 'ID' );
                            task_index = self.getIndex( self.$store.state.lists[list_index].tasks, self.task.ID, 'ID' );

                        self.$store.commit( 'subtaskUnDone', {
                            list_index: list_index,
                            task_index: task_index,
                            subtask_index: index,
                            meta: {
                                completed_on: '',
                                completed_by: ''
                            }
                        } );

                        self.task.subtasks[index].completed = 0;
                        self.task.subtasks[index].completed_on = '';
                        self.task.subtasks[index].completed_by = '';
                    }
                }
            });
        },
        getSubtask: function() {
            var self = this,
                form_data = {
                    task_id: this.task.ID,
                    _wpnonce: CPMST_var.nonce,
                };

            wp.ajax.send('cpmst_get_subtasks', {
                data: form_data,
                success: function(res) {
                    self.task.subtasks = res.subtasks;
                    self.subtasks = res.subtasks;
                }
            });
        },

        /**
         * Delete task
         *
         * @return void
         */
        deleteSubTask: function( subtask_id ) {
            if ( ! confirm( 'are you sure') ) {
                return;
            }

            var self  = this,
                index = this.getIndex( this.subtasks, subtask_id, 'ID' );
                form_data  = {
                    subtask_id: subtask_id,
                    _wpnonce: CPMST_var.nonce,
                };

            wp.ajax.send('cpm_subtask_delete',{
                data: form_data,
                success: function(res) {
                    var list_index = self.getIndex( self.$store.state.lists, self.task.post_parent, 'ID' );
                        task_index = self.getIndex( self.$store.state.lists[list_index].tasks, self.task.ID, 'ID' );

                    self.$store.commit( 'subtaskDelete', {
                        list_index: list_index,
                        task_index: task_index,
                        subtask_index: index
                    } );

                    if ( self.$store.state.is_single_task ) {
                        self.subtasks.splice(index, 1);
                    }
                }
            });
        },

        editSubTask: function(subtask) {
            subtask.edit_mode = true;
        }
    }
});

Vue.component('cpm-subtask-new-form', {
    template: '#tmpl-cpm-subtask-new-form',
    props: ['task', 'subtask'],

    mixins: [CPM_Task_Mixin, CPM_Subtask],

    /**
     * Initial data for this component
     *
     * @return obj
     */
    data: function() {
        return {
            project_users: this.$store.state.project_users,
            submit_disabled: false,
            before_edit: jQuery.extend( true, {}, this.subtask ),
            show_spinner: false,
        }
    },

    computed: {
        /**
         * Get and Set task users
         */
        task_assign: {
            /**
             * Filter only current task assgin user from vuex state project_users
             *
             * @return array
             */
            get: function () {
                var filtered_users = [];

                if ( this.subtask.assigned_to && this.subtask.assigned_to.length ) {
                    var assigned_to = this.subtask.assigned_to.map(function (id) {
                        return parseInt(id);
                    });


                    filtered_users = this.project_users.filter(function (user) {
                        return (assigned_to.indexOf(parseInt(user.id)) >= 0);
                    });
                }

                return filtered_users;
            },

            /**
             * Set selected users at task insert or edit time
             *
             * @param array selected_users
             */
            set: function ( selected_users ) {
                this.subtask.assigned_to = selected_users.map(function (user) {
                    return user.id;
                });
            },
        },
    },

    methods: {
        getStartDate: function(subtask, event) {
            var self = this;
            setTimeout(function() {
                subtask.start_date = event.target.value;
            },300);
        },

        getDuetDate: function(subtask, event) {
            var self = this;
            setTimeout(function() {
                subtask.due_date = event.target.value;
            },300);
        },

        /**
         * Insert and edit task
         *
         * @return void
         */
        newSubTask: function() {
            // Exit from this function, If submit button disabled
            if ( this.submit_disabled ) {
                return;
            }

            // Disable submit button for preventing multiple click
            this.submit_disabled = true;

            var self      = this,
                is_update = typeof this.subtask.ID == 'undefined' ? false : true,

                form_data = {
                    action: is_update ? 'cpmst_task_update' : 'cpmst_task_add',

                    subtask_assign: this.subtask.assigned_to,
                    subtask_text: this.subtask.post_content,
                    subtask_start: this.subtask.start_date,
                    subtask_due: this.subtask.due_date,

                    task_id: this.task.ID,
                    subtask_id: is_update ? this.subtask.ID : false,
                    _wpnonce: CPMST_var.nonce,
                },
                is_single_task = this.$store.state.is_single_task,
                index = this.getIndex( this.task.subtasks, this.subtask.ID, 'ID' );

            // Showing loading option
            this.show_spinner = true;

            // Sending request for insert or update task
            jQuery.post( CPMST_var.ajaxurl, form_data, function( res ) {

                if ( res.success ) {

                    self.show_spinner = false;

                    // Display a success toast, with a title
                    toastr.success(res.data.success);

                   var list_index = self.getIndex( self.$store.state.lists, self.task.post_parent, 'ID' );
                       task_index = self.getIndex( self.$store.state.lists[list_index].tasks, self.task.ID, 'ID' );


                    if ( is_update ) {

                        self.subtask.edit_mode = false;
                        self.$store.commit( 'subtaskUpdate', {
                            list_index: list_index,
                            task_index: task_index,
                            subtask_index: index,
                            subtask: res.data.subtask
                        } );

                    } else {

                        self.$store.commit( 'newSubTask', {
                            list_index: list_index,
                            task_index: task_index,
                            subtask: res.data.subtask
                        } );

                        if (is_single_task) {
                            self.task.subtasks.push(res.data.subtask);
                        }

                        // Hide the todo list update form
                        self.showHideSubtskForm( self.task );
                    }

                } else {
                    self.show_spinner = false;

                    // Showing error
                    res.data.error.map( function( value, index ) {
                        toastr.error(value);
                    });
                }

                self.submit_disabled = false;
            });
        }
    }
});




