<?php

class CPMST_Sub_Task_Ajax {

    private $parent_class;

    public static function getInstance() {
        static $_instance = false;

        if ( !$_instance ) {
            $_instance = new CPMST_Sub_Task_Ajax();
        }
        return $_instance;
    }

    function __construct() {

        add_action( 'wp_ajax_cpmst_get_subtasks', array ( $this, 'get_subtasks' ) );
        add_action( 'wp_ajax_cpmst_task_add', array ( $this, 'insert_subtask' ) );
        add_action( 'wp_ajax_cpmst_subtask_complete', array ( $this, 'mark_subtask_complete' ) );
        add_action( 'wp_ajax_cpmst_subtask_open', array ( $this, 'mark_subtask_open' ) );
        add_action( 'wp_ajax_cpmst_mark_task_updte', array ( $this, 'mark_task_updte' ) );
        add_action( 'wp_ajax_cpmst_task_update', array ( $this, 'update_task' ) );
        add_action( 'wp_ajax_cpm_subtask_delete', array ( $this, 'delete_task' ) );
    }

    function delete_task() {
        check_ajax_referer( 'cpmst_subtask' );

        $task_id    = absint( $_POST[ 'subtask_id' ] );
        $this->delete_sub_task( $task_id, true );

        wp_send_json_success( array( 'success' => __( 'The subtask has been deleted successfully.', 'cpm-subtask' ) ) );
    }

    /**
     * Delete a sub task
     *
     * @param int $task_id
     * @param bool $force
     */
    function delete_sub_task( $task_id, $force = false ) {
        do_action( 'cpm_sub_task_delete', $task_id, $force );

        wp_delete_post( $task_id, $force );
    }

    function update_task() {
        $posted = $_POST;

        // removing empty fields
        $posted = array_filter( $posted );

        // validating subtask data
        $this->validate_data( $posted );

        $task_id     = $posted[ 'task_id' ];
        $sub_task_id = $posted[ 'subtask_id' ];

        $sub_task_id = $this->add_sub_task( $task_id, $sub_task_id );
        $sub_task    = cpm_subtask_get_task( $sub_task_id );

        if ( $sub_task_id ) {
            $response = array (
                'success' => __( 'The subtask has been updated successfully.', 'cpm-subtask' ),
                'subtask' => $sub_task,
            );
        } else {
            $response = array ( 'success' => false );
        }

        wp_send_json_success($response);
    }

    function mark_subtask_open() {
        check_ajax_referer( 'cpmst_subtask' );
        $subtask_id = absint( $_POST['subtask_id'] );
        cpm_subtask_open( $subtask_id );

        wp_send_json_success( array( 'success' => __( 'The subtask has been re-opened.', 'cpm' ) ) );
    }



    function mark_task_updte() {
        check_ajax_referer( 'cpmst_subtask' );
        $task_obj   = CPM_Task::getInstance();
        $posted     = $_POST;
        ///
        $task_id    = isset( $posted[ 'task_id' ] ) ? intval( $posted[ 'task_id' ] ) : 0;
        $list_id    = isset( $posted[ 'list_id' ] ) ? intval( $posted[ 'list_id' ] ) : 0;
        $project_id = isset( $posted[ 'project_id' ] ) ? intval( $posted[ 'project_id' ] ) : 0;
        $new_status = (isset( $posted[ 'cstatus' ] ) && $posted[ 'cstatus' ] == 1) ? 0 : 1;
        $response   = array ( 'success' => false );
        $is_assign  = $task_obj->check_task_assign( $task_id );
        $task_obj   = CPM_Task::getInstance();
        if ( cpm_user_can_delete_edit( $project_id, $task_id, true ) || $is_assign ) {
            if ( $new_status == 1 ) {
                $this->mark_complete( $task_id );
                $task_obj->mark_complete( $task_id );
            }else {
                $this->mark_open( $task_id );
            }

            $complete = $task_obj->get_completeness( $list_id, $project_id );
            $subtask     = $task_obj->get_task( $task_id );

            $stask_object =CPMST_Sub_Task::getInstance();
            $stask_object->set_task_meta( $subtask );
            $stask_object->set_subtask_extra_data($subtask) ;

            $user_id  = wp_get_current_user()->ID;

            $response = array (
                'success'         => true,
                // 'content'         => cpm_task_html( $task, $project_id, $list_id, $single ),
                // 'progress'        => cpm_task_completeness( $complete[ 'total' ], $complete[ 'completed' ] ),
                'task_complete'   => intval( $complete[ 'completed' ] ),
               // 'percent'         => $complete[ 'total' ] == 0 ? 100 : round( (100 * $complete[ 'completed' ]) / $complete[ 'total' ] ) . " %",
               // 'task_uncomplete' => ceil( $complete[ 'total' ] - $complete[ 'completed' ] ),
                'completed'       => $new_status,
                'subtask'         => $subtask,
            );
        }
        ///

        echo json_encode( $response );
        exit;
    }

    /**
     * Mark a sub task as complete
     *
     * @param int $task_id task id
     */
    function mark_subtask_complete() {
        $subtask_id = absint( $_POST['subtask_id'] );
        cpm_subtask_completed( $subtask_id );

        wp_send_json_success(
            array(
                'success' => __( 'The subtask has been marked as completed.', 'cpm-subtask'),
                'subtask' => cpm_subtask_get_task( $subtask_id )
            )
        );
    }

    function insert_subtask() {
        check_ajax_referer( 'cpmst_subtask' );
        $posted = $_POST;

        // removing empty fields
        $posted = array_filter( $posted );

        // validating subtask data
        $this->validate_data( $posted );

        $task_id     = absint( $posted[ 'task_id' ] );
        $sub_task_id = isset( $posted[ 'subtask_id' ] ) ? absint( $posted[ 'subtask_id' ] ) : 0;
        $sub_task_id = $this->add_sub_task( $task_id, $sub_task_id );
        $sub_task    = cpm_subtask_get_task( $sub_task_id );

        if ( $sub_task_id ) {
            $response = array (
                'success'    => __( 'A new subtask has been created successfully.', 'cpm-subtask' ),
                'id'         => $sub_task_id,
                'subtask'    => $sub_task,
            );
        } else {
            $response = array ( 'success' => false );
        }

        wp_send_json_success( $response );
    }

    /**
     * Add a single task
     *
     * @param int $list_id task list id
     * @return int $task_id task id for update purpose
     */
    function add_sub_task( $task_id, $sub_task_id = 0 ) {
        $postdata     = $_POST;
        $task_obj     = CPM_Task::getInstance();

        $is_update    = $sub_task_id ? true : false;

        $content  = trim( $postdata[ 'subtask_text' ] );
        $assigned = isset( $postdata[ 'subtask_assign' ] ) ? $postdata[ 'subtask_assign' ] : array ( '-1' );
        $due      = empty( $postdata[ 'subtask_due' ] ) ? '' : cpm_to_mysql_date( $postdata[ 'subtask_due' ] );
        $start    = empty( $postdata[ 'subtask_start' ] ) ? '' : cpm_to_mysql_date( $postdata[ 'subtask_start' ] );

        $data = array (
            'post_parent'  => $task_id,
            'post_title'   => trim( substr( $content, 0, 40 ) ), //first 40 character
            'post_content' => $content,
            'post_type'    => 'cpm_sub_task',
            'post_status'  => 'publish'
        );

        $data = apply_filters( 'cpm_task_params', $data );

        if ( $sub_task_id ) {
            $data[ 'ID' ] = $sub_task_id;
            $sub_task_id  = wp_update_post( $data );
        }else {
            $sub_task_id = wp_insert_post( $data );
        }

        if ( $sub_task_id ) {
            $task_obj->assign_user( $sub_task_id, $assigned );

            $task_users = get_post_meta( $task_id, '_assigned' );
            $task_users = array_merge( $task_users, $assigned );
            $task_users = array_unique( $task_users );
            $task_obj->assign_user( $task_id, $task_users );

            update_post_meta( $sub_task_id, '_due', $due );

            if ( cpm_get_option( 'task_start_field', 'cpm_general' ) == 'on' ) {
                update_post_meta( $sub_task_id, '_start', $start );
            } else {
                update_post_meta( $sub_task_id, '_start', '' );
            }

            //initially mark as uncomplete
            if ( !$is_update ) {
                update_post_meta( $sub_task_id, '_completed', 0 );
            }

            if ( $is_update ) {
                do_action( 'cpm_sub_task_update', $task_id, $sub_task_id, $data );
            }else {
                do_action( 'cpm_sub_task_new', $task_id, $sub_task_id, $data );
            }
        }

        return $sub_task_id;
    }

    function get_subtasks() {
        check_ajax_referer( 'cpmst_subtask' );

        $posted    = $_POST;
        $task_id   = absint( $posted[ 'task_id' ] );
        $sub_tasks = cpm_subtask_get_tasks( $task_id );

        if ( ! empty( $sub_tasks ) ) {
            $response = array (
                'subtasks' => $sub_tasks
            );
        } else {
            wp_send_json_error( array() );
        }

        wp_send_json_success( $response );
    }

    private function validate_data( $data )
    {
        $validator = new CPM_Validator();

        $rules = [
            'subtask_text' => 'required',
            'subtask_start' => 'date',
            'subtask_due' => 'date',
        ];

        $error_messages = [
            'subtask_text.required' => __( 'Subtask title is required.', 'cpm' ),
            'subtask_start.date' => __( 'Start date is a date field and should be formatted as Y-m-d.', 'cpm' ),
            'subtask_due.date' => __( 'Due date is a date field and should be formatted as Y-m-d.', 'cpm' ),
        ];

        if ( !$validator->validate( $data, $rules, $error_messages ) ) {
            $validator->send_json_errors();
        }
    }

}

CPMST_Sub_Task_Ajax::getInstance();


