<?php
/**
 * Get all tasks based on a task list
 *
 * @param int $task_id
 *
 * @return object object array of the result set
 */
function cpm_subtask_get_tasks( $task_id ) {

    $args  = array(
        'post_parent'    => $task_id, 
        'post_type'      => 'cpm_sub_task', 
        'post_status'    => 'publish', 
        'order'          => 'ASC', 
        'orderby'        => 'menu_order',
        'posts_per_page' => '-1'
    );
    $args  = apply_filters( 'cpm_get_sub_task', $args );
    $tasks = get_posts( $args );

    foreach ($tasks as $key => $task) {
        cpm_subtask_set_task_meta( $task );
    }
    
    return $tasks;
}

/**
 * Get a single task detail
 *
 * @param int $task_id
 * @return object object array of the result set
 */
function cpm_subtask_get_task( $task_id ) {
    $task = get_post( $task_id );
    cpm_subtask_set_task_meta( $task );
    return $task;
}

/**
 * Set all the meta values to a single task
 *
 * @param object $task
 */
function cpm_subtask_set_task_meta( &$task ) {
    $task->completed    = intval( get_post_meta( $task->ID, '_completed', true ) );
    $task->completed_by = get_post_meta( $task->ID, '_completed_by', true );
    $task->completed_on = get_post_meta( $task->ID, '_completed_on', true );
    $task->assigned_to  = get_post_meta( $task->ID, '_assigned' );
    $task->due_date     = get_post_meta( $task->ID, '_due', true );
    $task->start_date   = get_post_meta( $task->ID, '_start', true );
    $task->edit_mode    = false;

    $task = apply_filters( 'cpm_set_subtask_meta', $task );
}


function cpm_subtask_completed( $subtask_id ) {
    update_post_meta( $subtask_id, '_completed', 1 );
    update_post_meta( $subtask_id, '_completed_by', get_current_user_id() );
    update_post_meta( $subtask_id, '_completed_on', current_time( 'mysql' ) );

    do_action( 'cpm_sub_task_complete', $subtask_id );
}

function cpm_subtask_open( $subtask_id ) {
    update_post_meta( $subtask_id, '_completed', 0 );
    update_post_meta( $subtask_id, '_completed_by', '' );
    update_post_meta( $subtask_id, '_completed_on', '' );

    do_action( 'cpm_sub_task_open', $subtask_id );
}




