<?php
/*
  Plugin Name: WP Project Manager - Sub Task
  Plugin URI: https://wedevs.com/products/plugins/wp-project-manager-pro/sub-task/
  Description: Sub Task add-on for WP Project Manager
  Version: 1.3
  Author: weDevs
  Author URI: http://wedevs.com
  Text Domain: cpm-subtask
  Doamin Path: /languages/
 */

/**
 * Copyright (c) 2016 weDevs. All rights reserved.
 *
 * Released under the GPL license
 * http://www.opensource.org/licenses/gpl-license.php
 *
 * This is an add-on for WordPress
 * http://wordpress.org/
 *
 * **********************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * **********************************************************************
 */

 /**
 * CPM Time trakcer class
 *
 * @author WeDevs
 */
class CPMST_Sub_Task {

    private $version = 1.3;

    public static function getInstance() {
        static $_instance = false;

        if ( !$_instance ) {
            $_instance = new CPMST_Sub_Task();
        }

        return $_instance;
    }

    function __construct() {

        add_action( 'cpm_loaded', array( $this, 'sub_task_loaded' ) );
    }

    function sub_task_loaded() {
        register_activation_hook( __FILE__, array( $this, 'activate') );

        // Define constants
        $this->define_constants();

        // Include required files
        $this->includes();

        // Initialize the action hooks
        $this->init_actions();

        // Initialize the action hooks
        $this->init_filters();

        // Create action after loading this plugin
        do_action( 'cpm_sub_task_loaded' );
    }

    /**
     * Inital filter for this plugin
     *
     * @since  1.3
     *
     * @return void
     */
    function init_filters() {
        add_filter( 'cpm_set_task_meta', array( $this, 'set_task_meta' ) );
    }

    /**
     * Initial action for this plugin
     *
     * @since  1.3
     *
     * @return void
     */
    function init_actions() {
        add_action( 'cpm_after_task_scripts', array( $this, 'after_task_scripts' ) );
        add_action( 'admin_footer', array( $this, 'admin_js_templates' ) );
        add_action( 'wp_footer', array( $this, 'admin_js_templates' ) );
        add_action( 'cpm_after_task_title', array( $this, 'list_add_subtask_button' ), 10 );
        add_action( 'before-cpm-task-components', array( $this, 'scripts' ) );
        add_action( 'cpm_task_single_after', array($this, 'subtask') );
        add_action( 'after_task_details', array($this, 'singel_task_subtask') );
        add_action( 'after-cpm-task-store', array( $this, 'load_mixin_script' ) );
        add_action( 'plugins_loaded', array( $this, 'load_textdomain' ) );
        add_action( 'cpm_task_update', array ( $this, 'update_subtasks_users'), 10, 3 );
    }

    function update_subtasks_users( $list_id, $task_id, $data ) {
        $cpm_task  = CPM_Task::getInstance();

        $sub_tasks = cpm_subtask_get_tasks( $task_id );
        $assigned_users = $data['assigned_users'];

        foreach ($sub_tasks as $sub_task) {
            $assigned_users = array_intersect($assigned_users, $sub_task->assigned_to);

            $cpm_task->assign_user( $sub_task->ID, $assigned_users );
        }
    }

    function after_task_scripts() {
        add_action( 'wp_enqueue_scripts', array($this, 'scripts') );
    }

    function load_mixin_script() {
        $suffix  = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
        wp_enqueue_script( 'cpm_sub_task_store', plugins_url( 'assets/js/cpm-subtask-store' . $suffix . '.js', __FILE__ ), array('jquery'), false, true );
    }

    function includes() {
        require_once CPM_SUBTASK_PATH . '/includes/functions.php';
        require_once CPM_SUBTASK_PATH . '/classes/ajax.php';
    }

    function set_task_meta( $task ) {
        $task->new_subtask_form = false;
        $task->subtasks = array();

        return $task;
    }

    /**
     * Define cpmrp Constants
     *
     * @since 1.1
     * @return type
     */
    public function define_constants() {
        $this->define( 'CPM_SUBTASK_VERSION', $this->version );
        $this->define( 'CPM_SUBTASK_PATH', dirname( __FILE__ ) );
        $this->define( 'CPM_SUBTASK_URL', plugins_url( '', __FILE__ ) );
        $this->define( 'CPM_SUBTASK_JS_TMPL', CPM_SUBTASK_PATH . '/views/js-templates' );
    }

    /**
     * Define constant if not already set
     *
     * @since 1.1
     *
     * @param  string $name
     * @param  string|bool $value
     * @return type
     */
    public function define( $name, $value ) {
        if ( ! defined( $name ) ) {
            define( $name, $value );
        }
    }

    /**
     * Load plugin textdomain
     *
     * @since 1.1
     */
    function load_textdomain() {
        load_plugin_textdomain( 'cpm-subtask', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
    }

    function delete_subtak_before_del_task( $task_id, $force ) {
        $subtasks = $this->get_tasks( $task_id );
        foreach ( $subtasks as $key =>  $subtask ) {
            cpm_delete_sub_task( $subtask->ID, true );
        }
    }

    function subtask_title_link_remove( $status, $task, $project_id, $list_id, $single ) {
        if ( $task->post_type == 'cpm_sub_task' ) {
            return false;
        }

        return true;
    }

    function instantiate() {
        require_once dirname( __FILE__ ) . '/classes/ajax.php';

        CPMST_Sub_Task_Ajax::getInstance( $this );
    }

    /**
     * Register post type for sub task
     *
     * @return void
     */
    public function register_post_type() {

        $args = array(
            'hierarchical'        => false,
            'public'              => false,
            'show_ui'             => false,
            'show_in_menu'        => false,
            'show_in_admin_bar'   => false,
            'show_in_nav_menus'   => false,
            'can_export'          => true,
            'has_archive'         => false,
            'exclude_from_search' => true,
            'publicly_queryable'  => false,
            'capability_type'     => 'post',
        );

        register_post_type( 'cpm_sub_task', $args );
    }

    function scripts() {
        $suffix  = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

        wp_enqueue_script( 'jquery' );
        wp_enqueue_script( 'cpm_subtask_mixin', plugins_url( 'assets/js/cpm-subtask-mixin' . $suffix . '.js', __FILE__ ), array('jquery'), false, true );
        wp_enqueue_script( 'cpm_subtask_script', plugins_url( 'assets/js/cpm-subtask' . $suffix . '.js', __FILE__ ), array('jquery'), false, true );

        wp_localize_script( 'cpm_subtask_script', 'CPMST_var', array(
            'ajaxurl' => admin_url( 'admin-ajax.php' ),
            'nonce'  => wp_create_nonce( 'cpmst_subtask' ),
            'no_subtask' => __( 'No Subtask Found', 'cpmst-subtask' )
        ) );
        wp_enqueue_style( 'cpmst_subtask', plugins_url( 'assets/css/style' . $suffix . '.css', __FILE__ ), false );
    }

    public function list_add_subtask_button() {
        echo '<span v-if="task.completed == 0">';
        echo '<div class="cpm-task-subtask"><cpm-subtask-new-button :task="task"></cpm-subtask-new-button></div>';
        echo '<div class="cpm-task-subtask"><cpmst-show-subtask :task="task"></cpmst-show-subtask></div>';
        echo '</span>';

    }

    function singel_task_subtask() {
        $this->list_add_subtask_button();
        $this->subtask();
    }

    function subtask() {
        echo '<cpm-subtasks :task="task"></cpm-subtasks>';
        echo '<div v-if="task.new_subtask_form"><cpm-subtask-new-form :task="task" :subtask="{}"></cpm-subtask-new-form></div>';

    }

    /**
     * HTML form generator for new/update task form
     *
     * @param int $list_id
     * @param int $project_id
     * @param null|object $task
     */
    function cpm_task_new_form( $list_id, $project_id, $task = null, $single = false ) {

        $action        = 'cpmst_task_add';
        $task_content  = $task_due = '';
        $assigned_to   = '-1';
        $submit_button = __( 'Add this sub task', 'cpm-subtask' );

        //for update form
        if ( !is_null( $task ) ) {
            $action        = 'cpmst_task_update';
            $task_content  = $task->post_content;
            $assigned_to   = $task->assigned_to;
            $submit_button = __( 'Save Changes', 'cpm-subtask' );

            if ( $task->due_date != '' ) {
                $task_due = date( 'Y-m-d', strtotime( $task->due_date ) );
            }
        }

        if ( isset( $task->start_date ) && $task->start_date != '' ) {
            $task_start = date( 'Y-m-d', strtotime( $task->start_date ) );
        } else {
            $task_start = '';
        }
        ?>

        <form action="" method="post" class="cpmst-sub-task">
            <input type="hidden" name="list_id" value="<?php echo $list_id; ?>">
            <input type="hidden" name="project_id" value="<?php echo $project_id; ?>">
            <input type="hidden" name="action" value="<?php echo $action; ?>">
            <input type="hidden" name="single" value="<?php echo $single; ?>">
            <?php wp_nonce_field( $action ); ?>

            <?php if ( $task ) { ?>
                <input type="hidden" name="task_id" value="<?php echo $task->ID; ?>">
            <?php } ?>

            <div class="item content">
                <textarea name="task_text" class="todo_content" cols="40" placeholder="<?php esc_attr_e( 'Add a new to-do', 'cpm-subtask' ) ?>" rows="1"><?php echo esc_textarea( $task_content ); ?></textarea>
            </div>
            <div class="item date">
                <?php if ( cpm_get_option( 'task_start_field' ) == 'on' ) { ?>
                    <div class="cpm-task-start-field">
                        <label><?php _e( 'Start date', 'cpm-subtask' ); ?></label>
                        <input  type="text" autocomplete="off" class="datepicker" placeholder="<?php esc_attr_e( 'Start date', 'cpm-subtask' ); ?>" value="<?php echo esc_attr( $task_start ); ?>" name="task_start" />
                    </div>
                <?php } ?>
                <div class="cpm-task-due-field">
                    <label><?php _e( 'Due date', 'cpm-subtask' ); ?></label>
                    <input type="text" autocomplete="off" class="datepicker" placeholder="<?php esc_attr_e( 'Due date', 'cpm-subtask' ); ?>" value="<?php echo esc_attr( $task_due ); ?>" name="task_due" />
                </div>
            </div>
            <div class="item user">
                <?php cpm_task_assign_dropdown( $project_id, $assigned_to ); ?>
            </div>

            <?php do_action( 'cpm_task_new_form', $list_id, $project_id, $task ); ?>

            <div class="item submit">
                <span class="cpm-new-task-spinner"></span>
                <input type="submit" class="button-primary cpmi-add-subtask-submit" name="submit_todo" value="<?php echo esc_attr( $submit_button ); ?>">
                <a class="button cpm-cancle-new-sub-task todo-cancel" href="#"><?php _e( 'Cancel', 'cpm-subtask' ); ?></a>
            </div>
        </form>
        <?php
    }

    /**
     * HTML generator for single task
     *
     * @param object $task
     * @param int $project_id
     * @param int $list_id
     *
     * @return string
     */
    function cpm_task_html( $task, $project_id, $list_id, $single = false, $completed_status = '' ) {
        $wrap_class    = ( $task->completed == '1' ) ? 'cpm-task-complete' : 'cpm-task-uncomplete';
        $cstatus_class = ( $task->completed == '1' ) ? 'cpmst-complete' : 'cpmst-uncomplete';
        $start_date    = isset( $task->start_date ) ? $task->start_date : '';
        $can_manage    = cpm_user_can_delete_edit( $project_id, $task );
        $user_id       = get_current_user_id();

        if ( is_array( $task->assigned_to ) ) {
            $assing_user = in_array( $user_id , $task->assigned_to ) ? true : false;
        } else {
            $assing_user = ( $user_id == $task->assigned_to ) ? true : false;
        }

        if ( $can_manage || $assing_user ) {
            $status_class = ( $task->completed == '1' ) ? 'cpm-complete' : 'cpm-uncomplete';
            $disabled = '';
        }

        ob_start();
        ?>
        <div class="cpm-todo-wrap <?php echo $wrap_class; ?>" >
            <?php
            if ( cpm_user_can_delete_edit( $project_id, $task ) ) {
                ?>

            <?php } ?>
            <?php
            if ( $completed_status == 1 ) {
                $check_status = 'disabled';
            } else {
                $check_status = '';
            }
            ?>
            <span class="cpm-spinner"></span>

            <span class="move"></span>
            <span class="cpm-todo-content">
                <input <?php echo $check_status; ?>  class="<?php echo $cstatus_class; ?>" type="checkbox" <?php cpm_data_attr( array('single' => $single, 'list' => $list_id, 'project' => $project_id) ); ?> value="<?php echo $task->ID; ?>" name="" <?php checked( $task->completed, '1' ); ?> >
                <?php if ( $single ) { ?>
                    <span class="cpm-todo-text"><?php echo $task->post_content; ?></span>
                <?php } else { ?>

                    <span class="cpm-todo-text"><?php echo $task->post_content; ?></span>

                <?php } ?>


                <?php
                //if the task is completed, show completed by
                if ( $task->completed == '1' && $task->completed_by ) {
                    $user = get_user_by( 'id', $task->completed_by );
                    $completion_time = cpm_get_date( $task->completed_on, true );
                    ?>
                    <span class="cpm-completed-by">
                        <?php printf( __( '(Completed by %s on %s)', 'cpm-subtask' ), $user->display_name, $completion_time ) ?>
                    </span>
                <?php } ?>

                <?php
                if ( $task->completed != '1' ) {

                     if ( reset( $task->assigned_to ) != '-1' ) {
                        cpm_assigned_user( $task->assigned_to );
                    }

                    if ( $task->due_date != '' || $start_date != '' ) { ?>
                        <span class="cpm-due-date">
                            <?php
                            if ( ( cpm_get_option( 'task_start_field' ) == 'on' ) && $start_date != '' ) {
                               echo cpm_get_date( $start_date, false, 'M d' ) ;
                            }
                            if ( $start_date != '' & $task->due_date != '' ) {
                                echo ' - ';
                            }
                            if ( $task->due_date != '' ) {
                              echo  cpm_get_date( $task->due_date, false, 'M d' ) ;
                            }
                            ?>
                        </span>
                        <?php
                    }
                }
                ?>
            </span>



            <?php if ( $task->completed == '0' && $completed_status != 1 ) { ?>
                <div class="cpmst-task-edit-form" style="display: none;">
                    <?php echo $this->cpm_task_new_form( $list_id, $project_id, $task ); ?>
                </div>
            <?php } ?>
            <?php
            if ( $completed_status != 1 && $task->completed != 1 ) {

            }
            ?>
            <span class="cpm-right cpmst-todo-action">
                <a href="#" class="cpmst-todo-delete" <?php cpm_data_attr( array('single' => $single, 'list_id' => $list_id, 'project_id' => $project_id, 'task_id' => $task->ID, 'confirm' => __( 'Are you sure to delete this to-do?', 'cpm-subtask' )) ); ?>>
                   <span class="dashicons dashicons-trash"></span>
                </a>
                <?php if ( $task->completed == '0' && $completed_status != 1 ) { ?>
                    <a href="#" class="cpmst-todo-edit"><span class="dashicons dashicons-edit"></span></a>
                <?php } ?>
            </span>
        </div>

        <?php
        return ob_get_clean();
    }



    /**
     * Placeholder for activation function
     *
     * Nothing being called here yet.
     */
    static function activate() {

        if ( !class_exists( 'WeDevs_CPM' ) ) {
            exit( '"WP Project Manager PRO" plugin is not installed. Install the plugin first.' );
            return;
        }

        self::upgrade_cpm_to_0_6();
    }

    /**
     * Upgrade cpm to 0.5.5
     *
     * Change task assign store process.
     *
     * @return type
     */
    static function upgrade_cpm_to_0_6() {
        $tasks = new WP_Query( array(
            'post_type'     => 'sub_task',
            'post_status'   => 'any',
            'post_per_page' => -1,
        ));

        foreach ( $tasks->posts as $key => $task ) {
            $assign_users = get_post_meta( $task->ID, '_assigned', true );

            if ( is_array( $assign_users ) ) {
                delete_post_meta( $task->ID, '_assigned' );
                foreach ( $assign_users as $key => $assign_user ) {
                    add_post_meta( $task->ID, '_assigned', $assign_user );
                }
            }
        }
    }

    /**
     * Create a duplicate sub task
     *
     * @param  int  $old_task_id
     * @param  int  $new_task_id
     *
     * @return void
     */
    function create_duplicate_subtask ($old_task_id, $new_task_id){

        $task = array(
            'post_parent' => $old_task_id,
            'post_type'   => 'cpm_sub_task',
            'post_status' => 'publish',
            'order'       => 'ASC',
            'orderby'     => 'ID'
        );

        $sub_task_data = get_children( $task );

        foreach ( $sub_task_data as $sub_task ){

            $sub_task->post_parent = $new_task_id ;
            $sub_task->ID = '';

            wp_insert_post($sub_task) ;
        }

    }

    /**
     * Print JS templates in footer
     *
     * @since  2.0.0
     *
     * @return void
     */
    public function admin_js_templates() {

        cpm_get_js_template( CPM_SUBTASK_JS_TMPL . '/new-subtask-button.php', 'cpm-subtask-new-button' );
        cpm_get_js_template( CPM_SUBTASK_JS_TMPL . '/new-subtask-form.php', 'cpm-subtask-new-form' );
        cpm_get_js_template( CPM_SUBTASK_JS_TMPL . '/subtasks.php', 'cpm-subtasks' );
        cpm_get_js_template( CPM_SUBTASK_JS_TMPL . '/show-subtask.php', 'cpmst-show-subtask' );
        //cpm_get_js_template( CPM_SUBTASK_JS_TMPL . '/time-log.php', 'cpmtt-time-log' );
        //cpm_get_js_template( CPM_SUBTASK_JS_TMPL . '/custom-time.php', 'cpmtt-custom-time' );
        //cpm_get_js_template( CPM_SUBTASK_JS_TMPL . '/admin-view-log.php', 'cpmtt-admin-view-log' );
    }
}


$instance = CPMST_Sub_Task::getInstance();




/**
 * Delete a sub task
 *
 * @param int $task_id
 * @param bool $force
 */
function cpm_delete_sub_task( $task_id, $force = false ) {
    do_action( 'cpm_sub_task_delete', $task_id, $force );
    wp_delete_post( $task_id, $force );
}
